<?php
/*
Plugin Name: YITH Remove WP User Registration buttons
Description: Remove WP User Registration buttons from classic editor for vendors
Author: YITH
Version: 1.0.0
Author URI: http://yithemes.com/
*/
/*
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly 

add_action( 'init', 'yith_wcmv_remove_editor_buttons', 30 );

if( ! function_exists( 'yith_wcmv_remove_editor_buttons' ) ){
	function yith_wcmv_remove_editor_buttons(){
		if( function_exists( 'yith_get_vendor' ) ){
			$vendor = yith_get_vendor( 'current', 'user' );
			if( $vendor->is_valid() && $vendor->has_limited_access() ){
				add_filter( 'ur_display_media_button', '__return_false' );
			}
		}
	}
}